;*** 
;rtinterp.inc - runtime error handling support
;
;	Copyright <C> 1986, 1987, 1988 Microsoft Corporation
;
;
;*******************************************************************************

RTINTERP_INC = ON

;**================ Client Error Range Constants =========================
; Embedded BASIC could be used to support a number of different
; "clients", such as Omega, Opus, etc, acting as a macro package.
; Command equivalent and other runtime calls can cause trappable
; runtime errors, where the error is generated by the client. We
; handle this by giving each client their own range of error codes,
; all of which fit in the same runtime error number space as existing
; BASIC runtime error numbers.
; NOTE: These constants must match what's in EBAPI.H.
;=======================================================================**

;**=========================== ERRRET ====================================
;
;errRet is used to for indirect calls to runtime; this allows error code
;	to fool caller into thinking the runtime just returned an error
;	code, if an error occurs.
;
;=======================================================================**

ERRRET		STRUC
ERRRET_saveSP	DW 0
ERRRET_saveBP	DW 0
ERRRET_saveSI	DW 0
ERRRET_saveDI	DW 0
ERRRET_retAddr	DW 0
ERRRET		ENDS


sBegin	DATA
	EXTRN	errCodeRet:byte ;state for indirect calls to runtime
sEnd	DATA

ife	RTERROR_ASM
	EXTRN	ResetSP_BP_FAR:far	
	EXTRN	CallRtTrap:far
	EXTRN	CallRtTrap_Parm:far
	EXTRN	CallRtTrap_RT:far
	EXTRN	CallRtTrap_CODE:far
sBegin	CP
	EXTRN	RtSetTrap:near
	EXTRN	RtFreeTrap:near
	EXTRN	RtPushHandler:near
	EXTRN	RtPopHandler:near
sEnd	CP
	EXTRN	RtErrorOM_INI:far
	EXTRN	RtError:far
	EXTRN	RtErrorNoSi:far
sBegin	CODE
	EXTRN	RtErrorCODE:near
sEnd	CODE
endif
