        page    80,132
;******************* START OF SPECIFICATIONS ***********************************
;
;	Microsoft Confidential
;	Copyright (c) Microsoft Corporation 1991
;	All Rights Reserved
;
; MODULE NAME:          SYS1.ASM + SYS2.ASM + SYSSR.ASM
;
; DESCRIPTIVE NAME:     SYS
;
; FUNCTION:             Copies system programs BIOS.SYS and
;                       MSDOS.SYS onto a specified media.
;
; ENTRY POINT:
;
; INPUT:
;
; EXIT NORMAL:
;
; EXIT ERROR:
;
; INTERNAL REFERENCES:
;
;       ROUTINES:
;
;       DATA AREAS:
;
; EXTERNAL REFERENCES:
;
;       ROUTINES:
;
;       DATA AREAS:
;
; NOTES:  Version 4.0 is a MAJOR diversion from all previous versions of DOS.
;
;         In all older versions of SYS the target diskette, HAD to meet the
;         following criteria in order to be SYSed:
;                       - there must be enough physical room for BIOS and
;                         MSDOS.
;                       - the first data cluster (#2) had to be either not
;                         used - or owned by IBMBIO allready on the disk
;                       - The first 2 root DIR entries had to be unused, deleted
;                          or owned by IBMBIO and IBMDOS.
;
;         4.0 SYS is far less restrictive.
;                       - there must still be enough physical room for BIOS
;                         and MSDOS.
;                       - SYS will free up all required data clusters required
;                         by MSBIO.
;                       - The 2 root DIR entries for MSDOS and BIOS may
;                         be anywhere in the root.  SYS will move entrys
;                         in order for BIOS and MSDOS to be in their proper
;                         positions.
;        *** NOTE ****  - Sys will operate on DOS 3.2, 3.3 and 4.0.
;                         This has reqired a HARD CODED lower bound - DOS_low
;                         that is set in this file to 3.20
;
; REVISION HISTORY: Ax000  Version 4.0  05/01/87 - first release             FG
;                   Ax001          4.0  PTR P324                         D Love
;                   Ax002          4.0  PTR P583                             FG
;                   Ax003          4.0  DCR D4    - sys anything,anywhere    FG
;                   Ax004          4.0  DCR D201  - extended arbib change    FG
;                   Ax005          4.0  PTR P1334 - 1.2 MB + system  hang    FG
;                   Ax006          4.0  PTR P1403 - BIO & DOS wrong spots    FG
;                   Ax007          4.0  PTR P1404,5 - DIR search error       FG
;                   Ax008          4.0  PTR P1406 - IOCTL to INT 21-69       FG
;                   Ax009          4.0  PTR P1637 - full 720KB error         FG
;                   Ax010          4.0  PTR P1764 - single file error        FG
;                   Ax011          4.0  PTR P1772 - IBMBIO cluster chain     FG
;                   Ax012          4.0  PTR P1710 - ASSIGN or SUBST invalid  FG
;                   Ax013          4.0  PTR P1872 - ROOT restoration problem FG
;                   Ax014          4.0  PTR P1884 - more ROOT problems       FG
;                   Ax015          4.0  PTR P2165 - ROOT DIR above #100h sec.FG
;                   Ax016          4.0  DCR D304  - change in BOOT.INC       FG
;                   Ax017          4.0  PTR P2356 - HILDA error message      FG
;                   Ax018          4.0  PTR P2769 - no system on default drv FG
;                   Ax019          4.0  DCR D380  - run on current VER -1    FG
;                   Ax020          4.0  PTR P3028 - run using PATHGEN        FG
;                   Ax021          4.0  DCR D494  - add "source" & DOS 3.2   FG
;                   Ax022          4.0  PTR P3728 - wrong network message    FG
;                   Ax023          4.0  DCR D503  - Version is now 4.0       FG
;                   Ax024          4.0  PTM P3905 - fix parse error format   FG
;                   Ax025          4.0  PTM P4118 - fix message error        FG
;
; PRE-VERSION 4.0 HISTORY:
;
;   1.6     05/21/82    Added rev number message
;   1.61    06/04/82    Allow SYS to blank disk TimP at SCP
;   1.70    06/30/82    NON contiguous DOS allowed on 2.00 IBM.  Allows SYS to
;                       1.0 1.1 disks.
;   1.71    07/02/82    Put in CHDIRs to make sure everything done in root dir.
;   1.80    04/26/83    MZ make sys work in small machines; use full 2.0
;                       system calls
;   1.81    07/22/83    ARR Added check in IBM version for valid FAT ID on
;                       destination because of IBM problem with SYSing to
;                       unformatted disks which are really formatted.  Prints
;                       NoDest message for ridic IBM reasons, should have a
;                       better message.
;   1.82    08/12/83    ARR ZIBOed again.  Mark fails to check for errors on
;                       his file I/O.  Results in SYS saying system
;                       transferred when it hasn't been.
;   1.83    09/08/83    EKE Added code to quit if sys called on a drive across
;                       a net.
;   1.84    09/09/83    CHRISP grabbed against his will to make this stupid
;                       program write out a boot sector
;   1.85    10/18/83    NP Printf to print messages and it's now an .EXE file
;   1.86    11/8/83     MZ fix hard file output of boot sector
;   1.87    5/1/84      MZ make sys prompt for system disk in default drive.
;   3.20    11/9/84     RS make sys write out a correct boot sector for the
;                       version of DOS. It grabs the boot sector off the system
;                       disk and inserts the correct BPB.
;                       Uses IOCTL Get Device Parms to get BPB for a Hard drive.
;   3.20    08/5/85     RS Allow FAT ID byte of 0F0H for 'strange' media
;                       layouts. These come about because of /T /N switches in
;                       FORMAT.
;   3.20    09/16/85    Incorporate tables of filenames to allow system files
;                       used by other OEMs to be SYSed onto disks formatted on
;                       other MSDOS systems. Allows the flexibility to replace
;                       system files for one OEM by system files for another.
;
;
;   3.30    06/04/86    MT removes initial check for IBMBIO and DOS - not needed
;                       because of later search of dirs
;   3.30    06/16/86    MT only force part of IBMBIO contig - do this by assuming
;                       contig part smaller than 1.10 BIOS
;   3.30    06/16/86    MT Check diks space for enough room to install BIO and DOS
;
; POST-VERSION 4.0 HISTORY:
;
;    Date    Who   #			  Description
;  --------  ---  ---  ------------------------------------------------------
;  02/05/91  DLB  M011 Added "no_mem" and "XFER_BUF".
;
;******************* END OF SPECIFICATIONS *************************************
        BREAK   <SYS1 - Program Organization>
;******************+ START OF PSEUDOCODE +**************************************
;
;Ŀ   Ŀ     Ŀ
; Main ´Init_Input_Output´SysLoadMsg (DOS version check)
;      
;                                 Ŀ
;                                 Parse_Command_Line
;                                  
;          Ŀ Ŀ
;          ôValidate_Target_Drive´Check_Default_Drive
;          ٳ
;                                 Ŀ
;                                 ôCheck_Target_Drive
;                                 
;                                 Ŀ
;                                 Check_For_Network
;                                  
;          Ŀ      Ŀ
;          ôGet_System_Files´Prompt_For_Media
;               
;                                 Ŀ
;                                 ôCheck_Removable
;                                 
;                                 Ŀ
;                                 ôOpen_File
;                                 
;                                 Ŀ
;                                 Fill_Memory
;                                  
;          Ŀ  Ŀ
;          ôCheck_SYS_Conditions´Verify_File_System
;           
;                                 Ŀ                 
;                                 ôRead_DirectoryĴPrompt_For_Media
;                                                  
;                                 Ŀ
;                                 ôVerify_File_Location
;                                 
;                                 Ŀ   Ŀ
;                                 Determine_Free_SpaceĴGet_Cluster
;                                     
;          Ŀ                Ŀ          Ŀ
;          ôDo_SYS´Create_SystemĴCreate_File
;                                   
;                                      Ŀ
;                                 ôFill_Memory
;                                      
;                                 Ŀ
;                                 Dump_Memory
;                                  
;          Ŀ                Ŀ
;          ôDo_End´Close_Files
;                         
;                                 Ŀ      Ŀ
;                                 Write_Boot_Record´Create_Serial_ID
;                                       
;                                                          Ŀ
;                                                          FAT_Size
;                                                           
;          Ŀ            Ŀ
;          Message   ĴGet_DOS_Error
;                       
;
;******************-  END  OF PSEUDOCODE -**************************************
        BREAK   <SYS - Segment Definition>
                                        ;---------------------------------------
                                        ;  NOTE: Structures used by SYS include:
                                        ;
                                        ;   find_buf           - DTA mapper
                                        ;   a_bpb              - EBPB struc
                                        ;   dir_entry          - Directory struc
                                        ;   A_DeviceParameters - IOCtl struc
                                        ;   BootForm           - Boot Rec struc
                                        ;---------------------------------------


;       INCLUDE DOSSYM.INC              ;also defines version of dos
.xlist
.xcref
        INCLUDE DOSSYM.INC
	include bpb.inc
.cref
.list


;       INCLUDE IOCTL.INC               ; Get / Set Device Parameters IOCTL
.xlist
.xcref
        INCLUDE IOCTL.INC
.cref
.list


;       INCLUDE BOOTFORM.INC            ; Boot Record Structure
.xlist
.xcref
        INCLUDE BOOTFORM.INC
.cref


;       INCLUDE PATHMAC.INC            ; PATH macro for PATHGEN
.xlist
.xcref
        INCLUDE PATHMAC.INC
.cref
.list

;IBMJAPVER EQU	 FALSE			 ; this and the following are mutually	MSKK01 07/18/89
;IBMVER  EQU	 TRUE			 ; exclusive				MSKK01 07/18/89

CODE    SEGMENT PARA PUBLIC
CODE    ENDS

DATA    SEGMENT PARA PUBLIC
DATA    ENDS

; The following must be defined to turn on the code which relocates the
; owner of the first few clusters, if it is not IBMBIO.  Although the
; entire IBMBIO file need not be contiguous, the number of clusters
; required to contain IBMLOADSIZE sectors (defined in BOOTFORM.INC) must
; be.  These sectors need not be located in the first sectors of the disk's
; data area, but we still claim the first clusters, rather than rewrite the
; code which moves things around.

NEED_CLUSTER_2  equ     TRUE            ; this must be defined to turn on
                                        ; the code which relocates the
                                        ; owner of the first few clusters
                                
                                        ;--------------------------------------
                                        ; constants
                                        ;--------------------------------------

DOS_low                 equ  0300h + 20 ; 3 in high reg, 20 in low reg.        ;AN023;
not_used                equ  0          ; filler for INT 21's
num_2_letter            equ  040h       ; turn dirve number to letter
dev_local               equ  9          ; IOCtl - get device parameters
removable               equ  01h        ; for testing removeability
net_drive               equ  01000h     ; for testing net drive
DOS_system_atrib        equ  7          ; DOS system file atributes
DOS_volume_atrib        equ  8          ; DOS volume label atribute
error_RC                equ  1          ; error return code
any_error               equ  255        ; mask for detecting errors
success                 equ  0          ; successful completion of SYS
LSeek_EOF               equ  2          ; seek relative to eof
LSeek_Start             equ  0          ; seek relative to beginning
old_type_media          equ  26         ; DOS extended error - old type media
file_not_found          equ  2          ; DOS extended error - file not found
file_spec_length        equ  11         ; length of file name
empty                   equ  0          ; empty directory entry
deleted                 equ  0E5h       ; entry is deleted
SetAtrib                equ  01h        ; set file attributes
set                     equ  1          ; set file date and time
BIG_FAT_THRESHOLD       equ  4086       ; size break for FAT12 - FAT16
PRELOAD                 equ  1          ; normal preload
return_error            equ  1          ; SYS return error code
FQ_DOS_DIR_CON_INP      equ  07h        ; Flush Queue / Direct CON in no echo
hard_drive              equ  0F8H       ; Media Descriptor for Hard drive
first_drive             equ  80H        ; first physical hard drive number
noerror                 equ  0          ; no errors
FAT_sect_size           equ  12         ; FAT sector count
dot                     equ  02Eh       ; Sub DIR DOT
bad_sector              equ  0F7h       ; FAT bad sector mark
end_cluster             equ  0FFh       ; FAT last cluster mark
not_found               equ  0FFh       ; current cluster not yet found
cluster_ent_per_sect    equ  512/2      ; (bytes/sector) / (bytes/cluster entry)
                                        ;    = cluster entries / sector
clusters_loaded         equ  cluster_ent_per_sect * FAT_sect_size ; = # of cluster
                                        ;    entries loaded in 12 sectors.

FAT_BUF                 equ  512 * 13   ; This space is used to do a number
                                        ;  of tasks. It existes at the START
                                        ;  of BUF. It is used as a 1 sector
                                        ;  buffer for processing DIR sector
                                        ;  manipulation. It is also used to
                                        ;  process the FAT. NOTE: a 12 bit fat
                                        ;  has a max. of FFFh (4K) entries - or
                                        ;  6K of space - or 12 sectors (512 bytes)
                                        ;  an extra 512 bytes is added for safety

XFER_BUF                equ  4096       ; M011: Minimum Transfer buffer size
                                        ;  (an arbitrary, but reasonable
                                        ;  value).  The actual Transfer buffer
                                        ;  may be larger than this.

                                        ;----------------------------------------
                                        ;  definition of the MODE bits
                                        ;     for an extended open
                                        ;----------------------------------------

;                 BITS DEFINED FOR THE MODE WORD
;                       FORMAT = 0WF0000CISSS0AAA
;              Write   ٳ        Access code
;                0 = no commit                      0 = read
;                1 = auto commit                    1 = write
;                                                   2 = read/write
;          Fail action                  3 = execute
;            0 = INT 24h                             4 = FCB
;            1 = return error           
;                                         Sharing mode
;             Code Page support ٳ         0 = compatability
;               0 = validate code page            1 = deny read/write
;               1 = no code page check            2 = deny write
;                                                 3 = deny read
;                                                 4 = deny none
;                                      Inherit
;                                        0 = pass handle to child
;                                        1 = no inherit
;
MODE_COM                equ  0100000000000000b ; Auto Commit
MODE_NO24               equ  0010000000000000b ; No 24 - return error
MODE_NOCP               equ  0000000100000000b ; No 24 - return error
MODE_NOINH              equ  0000000010000000b ; No child procees access
;                                            Sharing mode
;MODE_SH_COMP   equ       0000000000000000b        0 = compatability
MODE_SH_D_RW            equ  0000000000010000b ;    1 = deny read/write
MODE_SH_D_W             equ  0000000000100000b ;    2 = deny write
MODE_SH_D_R             equ  0000000000110000b ;    3 = deny read
MODE_SH_D_NONE          equ  0000000001000000b ;    4 = deny none
;                                            Access code
;MODE_AC_R      equ       0000000000000000b        0 = read
MODE_AC_W               equ  0000000000000001b ;    1 = write
MODE_AC_RW              equ  0000000000000010b ;    2 = read/write
MODE_AC_EXE             equ  0000000000000011b ;    3 = execute
MODE_AC_FCB             equ  0000000000000100b ;    4 = FCB

open_mode               equ  MODE_NO24+MODE_NOCP+MODE_NOINH+MODE_SH_D_RW+ MODE_AC_RW

                                        ;----------------------------------------
                                        ; Message Number Equates
                                        ;----------------------------------------

util                    equ  0ffh       ; all Utility messages
DOS_error               equ  1          ; DOS error CLASS
PARSE_error             equ  2          ; PARSE error CLASS
util_B                  equ  0bh        ; Utility CLASS B messages
                                        ;   (plain message)
util_C                  equ  0ch        ; Utility CLASS C messages
                                        ;   (insert message)
util_D                  equ  0dh        ; Utility CLASS D messages
                                        ;   (wait message)
extended_15             equ  15         ; DOS extended error 15
reqd_missing            equ  2          ; PARSE error 2

                                        ; CLASS B
no_room                 equ  7          ; No room for system on destination disk   Old
system_not_found        equ  8          ; Invalid path or System files not found   Old
done                    equ  9          ; System transferred                       Old
no_sys_on_def           equ  10         ; No system on default drive               Old
not_on_default          equ  11         ; Can not specify default drive            New
write_fail              equ  12         ; Write failure, diskette unusable         New
bad_path                equ  19         ; Invalid path
cant_read_system        equ  20         ; error reading system files
cant_sys_target         equ  21         ; SYS can not operate on target drive
CMD_NOT_PROCESSED	equ  25         ; can't transfer command.com
no_mem                  equ  26         ; M011: Insufficient memory

                                        ; CLASS C

cant_network            equ  13         ; Cannot %1 to a Network drive             Old
sys_disk                equ  14         ; Insert system disk in drive %1           Old
dest_disk               equ  15         ; Insert destination disk in drive %1      Old
cant_sys                equ  16         ; Not able to SYS to %1 file system        New
cant_assign             equ  18         ; Cannot %1 a SUBSTed or ASSIGNed drive    Old
src_targ_same           equ  19         ; Source path and target drive cannot be the same ;C04

                                        ; CLASS D

press_key               equ  17         ; Press any key to continue. . .           Change

MSG_OPTIONS_FIRST	equ	300	; first options help message
MSG_OPTIONS_LAST        equ     303     ;  last one


                        BREAK <SYS >

