        PAGE    ,132
        TITLE   'Power Control Transient Portion'

;-----------------------------------------------------------------------------
;       Power control transient module for POWER.EXE
;
;       This file contains the transient code used to turn power
;       monitoring on and off from the command line.
;
;       Microsoft Confidential
;       Copyright (C) 1991 Microsoft Corporation 
;       All Rights Reserved.
;
; This code is bound to the device driver image of POWER.EXE.  This
; transient program can be used to turn power control on and off.
; POWER has the following options:
;
; Command line syntax
;       POWER [ADV[:{MAX|REG|MIN}] | STD |OFF |SOUND |/?] 
;               ADV   - Monitors applications and devices
;			MAX = max.power savings switch
;			REG = default (medium) power savings switch
;			MIN = Minimum power savings
;               STD   - Monitors devices only
;		OFF   - turns off all pw. management
;               SOUND - activate speaker during idle (debug version only) - toggle
;               /? - print help message
;
; MODIFICATIONS:
;	M004	9/5/91	NSM	power status from APM in BL reg. was trashed
;				and so we were skipping call to get and print
;				APM stats. Fixed by storing status and
;				using it whenever we need to look at current
;				POWER status
;	M007	09/11/91 SMR	B#2669. Registered POWER's 2f channels
;					in mult.inc
;	M009	09/11/91 SMR	Build non-debug version.
;
;  	M010	09/12/91 SMR	PWR_API returns 0 in AX instead of no carry flag
;				in case of no error
;	M011	09/17/91 NSM	PWR_API returns the version no in AX for the
;				install_chk call and so we shouldn't chk for
;				AX==0 for install-chk call.
;	M087	09/23/91 NSM	Install_chk returns 504d in BX and not 4d50
;				B#2756
;
;	M089	09/25/91 NSM	UI changes.	
;
;	M092	10/18/91 NSM	B#2872(5.1) Clear out BH
;				(correction for a typo: xor was entered as or)
;
;	M012	12/04/91 SMR	Match lengths before comparing tokens
;
;-----------------------------------------------------------------------------

Bios_Code       segment word public 'Bios_Code'
		extrn	SecondCopy:byte
Bios_Code       ends

Bios_Data       segment word public 'Bios_Data'
Bios_Data       ends

SysInitSeg      segment word public 'system_init'
SysInitSeg      ends

Trans_Code      segment word public 'CODE'
Trans_Code      ends

Trans_Data      segment word public 'DATA'
Trans_Data      ends

Trans_Stack     segment para stack 'STACK'
        db      512 dup (?)
Trans_Stack     ends

break		macro		; satisfy mult.inc & pdb.inc		; M009
		endm							; M009

include		mult.inc				; M007
include         power.inc
include         pdb.inc

; DOS calls used
GET_VERSION	equ	30h
EXIT            equ     4Ch
OUT_STRING      equ     09h
OUT_CHAR        equ     02h

; miscellaneous equates
BLANK		equ	20h

Trans_Data      segment
include         powermsg.inc

psp             dw      0,0             ; stores our PSP address 

digit_buf       db      8 dup (0)       ; stores chars generated by get_dec

idle_data	IDLE_INFO	<>

pow_status	db	0		; M004 ; to store current POWER
					; enabled/disabled state
;NSM1 BEGIN

MAXTOKENSIZE	equ	12		; max limit for token size ; may
					; change for INTERNATIONAL

Token	db	MAXTOKENSIZE dup (0)	;

PW_Mode_Set	db	0		; flag ; set if we see a cmdline mode
					; keywords (ADV/STD/OFF)

		public	PW_Savings_Value,PW_Mode,PW_Low	; M104
PW_Savings_Value	dw	0	;
PW_Mode		db	0ffh		; OFF/STD/ADV = 0/2/3
PW_Low		db	0

IFDEF		DEBUG
		public	PW_Debug	; M104
PW_Debug	db	0
ENDIF

PW_LOADLOW	equ	10
PW_MODE_STD	equ	2
PW_MODE_OFF	equ	1

;NSM1 END


;NSM1 END


Trans_Data      ends

Trans_Code      segment
        assume  cs:Trans_Code, ds:nothing, es:nothing

        extrn   get_dec:near, uldiv:near, lmul:near        
        
start:
        public  start
        mov     ax,Trans_Data
        mov     ds,ax                   ; set up data segment
        assume  ds:Trans_Data

	mov	ah, GET_VERSION
	int	21h
	cmp	ax, 0005
	jae	@f			; Run on DOS 5.0 and above

	lea	dx, BadDOSMsg
	jmp	err_exit

@@:
        mov     [psp]+2,es              ; save our PSP address for later
        
; look at the command line and determine what we are supposed to be
; doing.  

        les     bx,dword ptr [psp]      ; recover our PSP address
        lea     di,es:[bx].PDB_TAIL
        cmp     es:[bx].PDB_TAIL,0      ; is there a command line?
	je	not_help		; no tail; go display stats
look_at_tail:
	inc	di			; skip the first blank in tail

clear_spaces:
        cmp     es:byte ptr [bx+di],' ' ; scan past any spaces
        jne     get_command_option      ; not a space, load it and check it
        inc     di
        jmp     short clear_spaces      ; assume we will stop on CR terminator

get_command_option:
        mov     ax,es:word ptr [bx+di]  ; get start of command line,
        cmp     ax,'?/'                 ; looks like /?
	jne	not_help
	jmp	display_help

not_help:

; We've established this is not /?.  Now check for other options        
; before proceeding, detect the presence of POWER by power detect call

	push	bx
	mov	ax,(MultPWR_API*256)+00h; POWER detect mult.call ; M007
	int	2fh
	cmp	ax,(MultPWR_API*256)+00h; MultAPI code unchanged ? ; M011
	jnz	chk_signature		; M011
to_open_fail:
	jmp	open_failed
chk_signature:
	cmp	bx,504dh		; M087 signature correct ?
	jne	to_open_fail

IFDEF	DEBUG
	push	di
        lea     dx,rev_msg      	; Display current rev. no & date
        mov     ah,OUT_STRING		;
        int     21h                     
	pop	di
ENDIF
	pop	bx

        mov     ax,es:word ptr [bx+di]  ; get start of command line,

        cmp     al,13                   ; is it the CR terminator?
        je      display_info            ; yes, just go display status
	cmp	al,0			; no tail at all
	je	display_info		; just display status

	add	di,bx			; es:di -> ptr to cmd line

	call	far ptr ParseCmdLine	; NSM1 - parse cmdline options
	call	SetPowerMode		; and set POWER's mode

display_info:   ; Print current state and idle stats
	mov	ax,(MultPWR_API*256)+I2F_PW_GET_SET_PWSTATE	; M007
	mov	bx,0			; get pw state
	int	2fh
	or	ax, ax			; M010
	jz	chk_status		; M010
	jmp	stats_failed		; error in get pw state ? just quit
chk_status:
	mov	[pow_status],bl		; M004
        lea     dx,power_stat1_msg      ; Display current POWER status
        mov     ah,OUT_STRING		; Whether "ADV/STD/OFF"
        int     21h                     

	or	bl,bl			; all pow.mgmt off ?
        lea     dx,power_off_msg         ; assume power control is off
	jz	got_msg			
	cmp	bl,2
	lea	dx,power_noid_msg
	je	got_msg
	xor	bx,bx
	mov	ax,(MultPWR_API * 256)+I2F_PW_GETSET_SAVINGS
	int	2fh			; get current savings value in bx
	lea	dx,power_advmax_msg
	cmp	bx,PW_ADV_REG
	ja	got_msg
	lea	dx,power_advreg_msg
	je	got_msg
	lea	dx,power_advmin_msg
got_msg:
        mov     ah,OUT_STRING		
        int     21h                     
	lea	dx,power_stat2_msg	; complete the above stat msg
        mov     ah,OUT_STRING		
        int     21h                     

; Compute percentage of time idle if idle detection is on
	test	[pow_status],1		;M004; is idle detection on ?
	jz	Print_APM_Stats
        lea     dx,cpu_idle_msg1
        mov     ah,OUT_STRING
        int     21h

	lea	si,idle_data
	mov	cx,size IDLE_INFO
	mov	ax,(MultPWR_API*256)+I2F_PW_GET_STATS	; M007
	mov	bx,PW_GET_IDLE_STATS	; get only idle detection stats
	int	2fh			; get stats
	or	ax, ax			; M010
	jnz	stats_failed		; M010

	lea	bx,idle_data
        push    word ptr [bx].CPU_IDLE_TIME+2
        push    word ptr [bx].CPU_IDLE_TIME   ; get total idle time
        xor     ax,ax
        push    ax
        mov     ax,100
        push    ax
        call    lmul                    ; returns result in DX:AX
        add     sp,8
        push    word ptr [bx].CPU_ON_TIME+2
        push    word ptr [bx].CPU_ON_TIME
        push    dx
        push    ax
        call    uldiv                   ; returns result in DX:AX
        add     sp,8

	call	calc_and_print_no
        
        lea     dx,cpu_idle_msg2
        mov     ah,OUT_STRING
        int     21h

Print_APM_Stats:
IFDEF	INCL_APM
	test	[pow_status],2		;M004; is APM enabled ?
	jz	good_exit		; no, all stats display over
	call	Display_APM_Stats
ENDIF
	

good_exit:      ; And exit

        xor     al,al
        mov     ah,EXIT
        int     21h


; Help message display

display_help:
        lea     dx,help_text
        mov     ah,OUT_STRING
        int     21h
        jmp     short good_exit


; Various error exits

open_failed:
        
        lea     dx,open_failed_msg
        jmp     short err_exit

stats_failed:
        lea     dx,stats_failed_msg
err_exit:
        mov     ah,OUT_STRING
        int     21h                     ; display error message
        mov     ah,EXIT
        mov     al,1                    ; signal error on exit 
        int     21h                     

; END OF Main (of transient POWER.EXE)

calc_and_print_no	proc	near
;dx:ax = no to print
;
        lea     di,digit_buf
        call    get_dec                 ; convert result to ASCII

        lea     bx,digit_buf

PrintASCIIZ	label	near
; ENTRY: bx = points to asciiz string

        mov     ah,OUT_CHAR
next_digit:
        mov     dl,[bx]                 ; reached end of string?
        or      dl,dl
        jz      capn_end              ; yes, go wrap up
        int     21h                     ; print the character
        inc     bx                      ; point to next char in string
        jmp     short next_digit
capn_end:
	ret

calc_and_print_no	endp

; NSM1 BEGIN
; ParseCmdLine:
; input:	es:di -> ptr to command line
; output:	CY    -> invalid cmd line option
;
; parses cmdline switches and does the necessary actions on them.
; If there are more than one switch specified in a given group, first one
; is taken and the second is flagged as an error and ignored.

		public	ParseCmdLine

ParseCmdLine	proc	far

	push	ds
	mov	ax, Trans_Data
	mov	ds, ax

PCL_NxtSwitch:
	call	GetNxtToken		; get next arg to be processed
					; [Token] filled in with current token
	jc	PCL_Ret			; end of cmd line ?

	call	GetTokenValue
	jc	PCL_Inv_CmdLine

IFDEF	DEBUG
	or	ax,ax
	jz	PCL_Toggle_Sound		;
ENDIF

	cmp	ax, PW_LOADLOW		; is it arequest for loadlow ?
	jne	PCL_ChkMode
	mov	PW_Low, 1
	jmp	PCL_NxtSwitch

PCL_ChkMode:
	test	PW_Mode_Set,1		; more than one mode switch ?
	jnz	PCL_Inv_CmdLine		; yes ,ignore this switch

	cmp	ax,PW_MODE_STD		;
	jbe	PCL_SetModes
	sub	ax,PW_MODE_STD		; ax = savings value
					; 1 = low, 2 med, 4 high
	mov	PW_Savings_Value,ax	
	mov	PW_Mode_Set,1		; mode is already set
	jmp	short turn_on_all	; go set ADV. mode

PCL_SetModes:
	mov	PW_Mode_Set,1		; mode is already set
	je	turn_on_FW		; Zr set if STD mode chosen
;
; else POWER OFF
turn_off:       ; User requests power control be deactivated
	xor	bl,bl		; turn off all pw mgmt
	jmp	short change_pw_state


; M089 END

IFDEF DEBUG
PCL_Toggle_Sound:
; User requests we toggle control of speaker on at idle
;
; SMR
;
IF	0
	mov	ax,(MultPWR_API*256)+02h; change allocation strategy ; M007
	mov	bl,80h			; special value for SOUND toggle
	int	2fh
ENDIF
	mov	PW_Debug, 1

	jmp	PCL_NxtSwitch
ENDIF

turn_on_all:        ; User requested power control be activated
	mov	bl,3			; set both F/W and S/W
;
change_pw_state:			; issue mult.int to turn on/off PW mgmt.

;
; SMR
;
IF	0

	mov	bh,1			; set  power state
	mov	ax,(MultPWR_API*256)+I2F_PW_GET_SET_PWSTATE	; M007
	int	2fh
	cmp	[PW_Savings_Value],0
	je	PCL_NxtSwitch
	mov	bx,[PW_Savings_Value]
	mov	ax,(MultPWR_API * 256)+I2F_PW_GETSET_SAVINGS
	int	2fh

ENDIF

	mov	[PW_Mode], bl
	
;
; SMR
;
        jmp     short PCL_NxtSwitch

turn_on_FW:
	mov	bl,2			; turn on only F/W
	jmp	short change_pw_state

PCL_Ret:
	mov	ax, PW_Savings_Value
	mov	bl, PW_Mode
	mov	dl, PW_Low
IFDEF	DEBUG
	mov	dh, PW_Debug
ENDIF
	pop	ds
	ret

PCL_Inv_CmdLine:
; print out Invalid command line and print the corresponding token
	push	ds
	mov	dx, Bios_Code
	mov	ds, dx
	assume	ds:Bios_Code
	cmp	SecondCopy, 0
	pop	ds
	assume	ds:Trans_Data
	jne	PCL_SkipErr

	lea	dx,bad_command_msg	
	mov	ah,OUT_STRING
	int	21h
	lea	bx,Token
	call	PrintASCIIZ		; print out the invalid token
	lea	dx,crlf_msg
	mov	ah,OUT_STRING
	int	21h
PCL_SkipErr:
        jmp     PCL_NxtSwitch

ParseCmdLine	endp

SetPowerMode	proc	near
;
	push	dx

	cmp	bl, 0ffh
	je	SPM_SkipMode

	push	ax
	mov	bh,1			; set  power state
	mov	ax,(MultPWR_API*256)+I2F_PW_GET_SET_PWSTATE	; M007
	int	2fh

	pop	ax
	or	ax, ax
	jz	SPM_SkipMode

	mov	bx,ax
	mov	ax,(MultPWR_API * 256)+I2F_PW_GETSET_SAVINGS
	int	2fh

SPM_SkipMode:

IFDEF	DEBUG
	pop	dx
	push	dx
	or	dh, dh
	jz	SPM_SkipDbg

	mov	ax,(MultPWR_API*256)+02h; change allocation strategy ; M007
	mov	bl,80h			; special value for SOUND toggle
	int	2fh
SPM_SkipDbg:
ENDIF
	pop	dx
	or	dl, dl
	jz	SPM_Exit
	lea	dx, PW_Low_ErrMsg
	mov	ah, OUT_STRING
	int	21h
SPM_Exit:
	ret
	
SetPowerMode	endp

GetNxtToken	proc	near
; es:di -> nxt token	
; regs used: AX,CX,SI,DI
GNT_SkipBlank:
	mov	al,es:[di]
	inc	di
	cmp	al,BLANK
	je	GNT_SkipBlank
;  leading blanks removed; copy the token
	lea	si,Token
	xor	cx,cx			; token size
GNT_NxtChar:
	cmp	al,0dh			; end of line ?
	je	GNT_EOLine
	cmp	al,0ah			; end of line ?
	je	GNT_EOLine
	or	al,al
	jz	GNT_EOLine
	cmp	al,BLANK
	je	GNT_EOToken
;****************************************************************************
; INTERNATIONAL : Here we have to get the lower case value for the current
; token into [Token] so that comparing against the standard Token_table entries
; in powermsg.inc will be easy.
	cmp	al, 'Z'
	ja	GNT_SkipCaseChng
	cmp	al, 'A'
	jb	GNT_SkipCaseChng

	or	al,20h			; CONVERT TO LOWER CASE
GNT_SkipCaseChng:
;****************************************************************************
	cmp	cx,MAXTOKENSIZE		; is the current string more than
					; max token size ?
	jae	GNT_NoStore		; if so, ignore the rest
	mov	ds:[si],al
	inc	si
	inc	cx
GNT_NoStore:
	mov	al,es:[di]
	inc	di
	jmp	GNT_NxtChar

GNT_EOToken:
	clc
GNT_Ret:
	mov	byte ptr ds:[si],0	; null terminate token
	ret
GNT_EOLine:
	jcxz	GNT_NoToken		; was there a token before EOL ? 
; token was terminated by a CR or NULL
	dec	di			; point to termination char
	jmp	short GNT_EOToken	
GNT_NoToken:
	stc				; CY to indicate end of cmdline args
	jmp	short GNT_Ret

GetNxtToken	endp
	

GetTokenValue	proc	near
; Entry:	
; 		[Token] = current token
;		es:di = command line switches
;		cl    = length of token
; EXIT:
;	CY	= invalid token
;	else
;	ax	= Token value from Token_Table
;
; Regs used:	AX,BX,CX,DX,SI
	
	push	es
	push	di

	push	ds
	pop	es

	lea	si,Token_Table
	lodsw
	mov	dx,ax 		;dx = no of tokens in token list
	mov	bh,cl		;bh = length of token			; M012
GTV_NxtToken:
	lea	di,Token
	lodsw			; get token length + token value
	mov	bl,al		; token value
	mov	cl,ah		; length of token
	xor	ch,ch
	cmp	bh, cl		; do lengths match?			; M012
	jne	GTV_LenMismatch	; no, try next key word			; M012
	rep	cmpsb		; compare given token with our list of tokens
	jz	GTV_Ret		; token matched
GTV_LenMismatch:							; M012
	add	si,cx		; skip to next entry in our list
	dec	dx		; end of all tokens ?
	jnz	GTV_NxtToken	; no, go for next token compar
; all tokens compared, but none matched ; fail
	stc
GTV_Ret:
	mov	bh, 0		; do not xor OR sub flags are being passed back
				; M012

	mov	ax,bx		; get token value from bx
	pop	di
	pop	es
	ret

GetTokenValue	endp

        
IFDEF	INCL_APM
	
batt_stat_table	label	word
	dw	battery_high
	dw	battery_low
	dw	battery_critical
	dw	battery_charging

;***************************************** Display_APM_Stats
; display APM statistics (ACLine status, Battery status and battery life)
;

Display_APM_Stats	proc	near
	mov	ax,530ah		; get power status
	mov	bx,1
	int	15h			;
	jc	APM_stats_End
	push	cx
	push	bx
	cmp	bh,-1
	je	go_chk_batt_stat
        lea     dx,ACLine_Stat1
        mov     ah,OUT_STRING
        int     21h
	pop	bx
	push	bx
        lea     dx,AC_Offline_str
	or	bh,bh
	je	go_print_acstat
	lea	dx,AC_Online_str
go_print_acstat:
        mov     ah,OUT_STRING
        int     21h
        lea     dx,ACLine_Stat2
        mov     ah,OUT_STRING
        int     21h

go_chk_batt_stat:
	pop	bx
	cmp	bl,-1
	je	go_print_batt_life
	xor	bh,bh		; M092
	push	bx
	lea	dx,battery_status1
        mov     ah,OUT_STRING
        int     21h
	pop	bx
	shl	bx,1		; word offset
	mov	dx,cs:batt_stat_table[bx]
        mov     ah,OUT_STRING
        int     21h

	lea	dx,battery_status2
        mov     ah,OUT_STRING
        int     21h

go_print_batt_life:
	pop	cx
	cmp	cl,-1
	je	APM_stats_End
	mov	ax,cx
	xor	ah,ah
	push	ax
	lea	dx,battery_life_str1
        mov     ah,OUT_STRING
        int     21h
	pop	ax
	xor	dx,dx
	call	calc_and_print_no
	lea	dx,battery_life_str2
        mov     ah,OUT_STRING
        int     21h
APM_stats_END:
	ret

Display_APM_Stats	endp

ENDIF

Trans_Code      ends

        end     start

